<?php

namespace VM\ViewerBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Exceptions\ApiException;


class DefaultController extends Controller
{
    public function indexAction($productCode)
    {
        try
        {
            /**
             * @var ApiGetter $ApiGetter
             */
            $ApiGetter = $this->get('vm_admin.api.getter');

            $dataPath = 'data/';
            $offerReports = array();

            if(!$ApiGetter->isTeacher($this->getUser()))
            {

                $Company = $ApiGetter->getUserCompanyOrFalse($this->getUser());

                /** @var CompanyOfferReport $CompanyOfferReport */
                foreach($Company->getCompanyOfferReports() as $CompanyOfferReport)
                {
                    $offerReports[] = $CompanyOfferReport->getReport()->getCode();
                }

                if(in_array($productCode, $offerReports))
                {
                    $dataPath = '/bundles/vmviewer/static/' . $productCode . '/data/';
                }
                else
                {
                    $User = $this->getUser();
                    $Group = $User->getGroup();
                    $CompanyReport = $ApiGetter->getCompanyReportByCode($productCode);
                    $ReportGroup = $CompanyReport->getCompany()->getUserGroups();
                    if($ReportGroup != $Group)
                    {
                        throw new \Exception('Report not exist');
                    }

                    $dataPath = $CompanyReport->getDataUrl() . '/data/';
                }
                $groupId = $this->getUser()->getGroupId();
            }
            else
            {
                $CompanyReport = $ApiGetter->getCompanyReportByCode($productCode);
                $Group = $CompanyReport->getCompany()->getUserGroups();
                if(!$this->getUser()->getAdminGroups()->contains($Group))
                {
                    throw new \Exception('Report not exist');
                }
                $dataPath = $CompanyReport->getDataUrl() . '/data/';
                $groupId = $Group->getId();
            }


            return $this->render('VMViewerBundle:Default:index.html.twig', array(
                'productCode' => $productCode,
                'User' => $this->getUser(),
                'groupId' => $groupId,
                'token' => $this->getRequest()->getSession()->get('user_sso_token'),
                'host' => str_replace('/notes', '', $this->get('service_container')->getParameter('notes.url')),
                'dataPath' => $dataPath
            ));
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }
}
